<?php 

// =================================================================
//
//			THIS IS THE FE - TRASHFOLDER - DIRLIST.PHP
//
//			FE by Sascha 'CyberTeddy' Schroeder
//			web:  www.cyber-inside.de
//				  blog.cyber-inside.de
//			mail: cyber at habmalnefrage dot de
//
//			=========================================
//
//			The dirlist.php is a kind of index which shows
//			a list of files n folders.
//			This dirlist.php contains the operations like 
//			rename,copy,remove and so on as well.
//
//			Note: The FileExplorer package contains: 
//			dirlist.php, fe-systemfolder and fe-trashfolder.
//			They 've to be in the same directory.
//			It's better you put all in the root-dir, 'cause FE don't care what's above.
//
// =================================================================



import_request_variables("gP", "rvar_");


// ======= THINGS TO SET UP FIRST ======================


// FE needs the absolute path to the fe-systemfolder 
// like: http://www.myserver.xy/systemfolder

$myserver = "http://localhost:8888/fileexplorer2/fe-systemfolder";
$myserver2 = "http://localhost:8888/fileexplorer2/fe-trashfolder";


$fe = 			$myserver."/fe.gif";
$imgfile = 		$myserver."/file.gif";
$imgfolder = 	$myserver."/folder.gif";
$imgnewfolder = $myserver."/new-folder.gif";
$imgfolderbig = $myserver."/folder-big.gif";
$imgstripe = 	$myserver."/stripe.gif";
$imgstripeup = 	$myserver."/stripe-up.gif";
$imgstripedown= $myserver."/stripe-down.gif";
$imgarrowdown = $myserver."/arrow-down.gif";
$imgclosebutton=$myserver."/close-button.gif";
$imgreload = 	$myserver."/reload.gif";
$imgtrashfolder=$myserver."/trash.gif";
$imgemptytrash =$myserver."/emptytrash.gif";
$imglevelup=	$myserver."/levelup.gif";
$imgroot =		$myserver."/root.gif";

$jqueryjs =		$myserver."/jquery.js";
$thickboxjs = 	$myserver."/thickbox.js";
$thickboxcss = 	$myserver."/thickbox.css";

// ======= THINGS TO SET UP FIRST ======================


?>



<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
    "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">

<head>
<title>FileExplorer <? readfile($myserver."/fileexplorer-current_version.txt"); ?></title>

<?

echo "
	<script type='text/javascript' src='$jqueryjs'></script>
	<script type='text/javascript' src='$thickboxjs'></script>

	<link rel='stylesheet' href='$thickboxcss' type='text/css' media='screen' />
	";
?>



<style type="text/css">
<!--
body {	background-color: #000000; color: #ffffff}
		
A:link {text-decoration: none; color: white;}
A:visited {text-decoration: none; color: white;}
A:active {text-decoration: none; color: white;}
A:hover {text-decoration: none; background-color: #F53D00; color: #ffffff;} //orange - white


-->
</style>





</head>
<body>

<?php // begin of PHP





$today = date("F j, Y, g:i a"); // todays date

$currentworkdir = getcwd(); // whole long path
$basedir = basename($currentworkdir); // just the last foldername


// ========== COUNTING FILES IN FOLDER ============================
function countFiles($path) // COUNT FILES
					  { 
					    $result = 0; 
					    $handle=opendir($path);  
			
					    while ($filec = readdir ($handle))  
					    {  
					       if ($filec != "." && $filec != ".."   && $filec != "dirlist.php"  && $filec != "fe-systemfolder" && $filec != "fe-trashfolder" && $filec != "readme.txt")
					         $result++; 
					    }  
					   closedir($handle); 
				  	  return $result;  
					  }
					  $c1 = countFiles("./"); 
// ==========END OF COUNTING FILES IN FOLDER ====================== 





// =========== MENU ==================================
echo "

<p style='background: url($imgstripeup); background-color: gray;'><img src='$imgclosebutton'> <b>File Explorer 2.0 beta</b></p>

<table width='100%'>
<tr>
	<td width='20%'> <img src='$fe' alt='FE-logo' border='0'> </td>
	<td width='50%'>Date: $today<br />
					$c1 objects in CurrentWorkDirectory<br />
					CWD: <b>$basedir</b><br />
					<a href='../dirlist.php'><img src='$imgroot' alt='Go to Root' title='Go to Root'></a> <a href='dirlist.php'><img src='$imgreload' alt='Reload' title='Reload'></a>
					<a href='dirlist.php?action=emptytrashform'><img src='$imgemptytrash' alt='Empty Trash' title='Empty Trash'></a></td>
					
	<td width='30%'>FE by CyberTeddy<br /> www.cyber-inside.de</td>
</tr>
</table>
<p>&nbsp;</p>";
// =========== MENU ==================================





// ==============================================
// HERE ARE THE ACTIONS
			switch ($rvar_action) 
				{
				
				
				
				case "emptytrashform" :
				
					echo "Empty trash: Are You Sure? <a href='dirlist.php?action=emptytrash'>YES</a> | <a href='dirlist.php'>NO</a>";
				
				break;
				case "emptytrash" :
				
					echo "Removing files: ";
				
					$handle=opendir('.');

					while ($file = readdir ($handle))

					{

						if ($file != "." && $file != ".." && $file != "dirlist.php" && $file != "readme.txt")

							{
			
								echo " $file, ";
								if (unlink($file))
								 	{  }
								 else
								 	{echo "Error removing file(s). function still missing to remove folders...";}

							}
					}
					closedir($handle);
					echo "<p>Done. </p>";
				
				break;
				
				
				
				
				case "remove" :
				
					$file = $_GET['file']; // get via link
				
					if (unlink($file))
						{ echo "$file removed. "; }
					else
						{
						echo "Error removing $file."; }
				break;
				
				
				
				
				case "restore" :
				
					$file = $_GET['file']; // get via link
				
				
					if (!file_exists("../".$file))
						{
				
				
							if (copy($file, "../".$file))
								{ unlink($file);
								echo "$file restored to <a href='../dirlist.php'>[ROOT]</a>. "; }
							else
								{ echo "Error restoring $file. function still missing to restore folders..."; }
						}
					else
						{
						$zufall = rand(1000, 9999);
						
						if (copy($file, "../".$zufall."_".$file))
								{ unlink($file);
								echo "".$file." already exists. Now restored with name ".$zufall."_".$file." to <a href='../dirlist.php'>[ROOT]</a>. "; }
							else
								{ echo "Error restoring $file. function still missing to restore folders..."; }
						
						}
					
				
				break;
				
					

				} // end of switch $action

// END OF ACTIONS
// ==============================================








// ==============================================
// HERE IS FILEEXPLORER SHOWING YOUR FILES

echo "<p>&nbsp;</p>
	<table width='100%'>
	<tr>
		<td style='background: url($imgstripe); background-color: gray;'>Name</td>
		<td style='background: url($imgstripe); background-color: gray;'>Kind</td>
		<td style='background: url($imgstripe); background-color: gray;'>Size (KB)</td>
		<td style='background: url($imgstripe); background-color: gray;'>Actions</td>
		<td style='background: url($imgstripe); background-color: gray;'>Last modified</td>
	</tr>";

$handle=opendir('.');

while ($file = readdir ($handle))

{

		if ($file != "." && $file != ".." && $file != "fe-systemfolder" && $file != "fe-trashfolder" && $file != "dirlist.php" && $file != "readme.txt")

		{
			// properties of file:
			$filesizebytes = filesize($file);
			$filesizekilo = $filesizebytes / 1024;
			$roundkilo = round($filesizekilo,2);
			
			$lastchange = date ('Y-m-d H:m', filemtime($file));
			
			
			

			
			// found file is a FOLDER!!
			if (is_dir($file))

			{
				 echo "<tr>
				 			<td><img src='$imgarrowdown' alt=''> <img src='$imgfolder' alt=''> ";
				 			if (file_exists($file."/dirlist.php"))
				 				{ echo "<a href='$file/dirlist.php'>$file</a><br />"; }
				 			else
				 				{ echo "<a href='$file'>$file</a><br />";}
				 			  
				 		
				 		
				 		//IF FOLDER COMNTAINS SOMETHING, SHOW IT TOO
				 		$handlef=opendir($file);
				 		while ($filef = readdir ($handlef))

							{

								if ($filef != "." && $filef != ".." && $filef != "fe-systemfolder" && $filef != "fe-trashfolder" && $filef != "dirlist.php")
								
								
								// IF file is  a FOLDER!!
								if (is_dir($file."/".$filef))
									{ echo " &nbsp; &nbsp; &nbsp; <img src='$imgfolder'> <a href='$imgfolderbig?hkeepThis=true&TB_iframe=true&height=300&width=500' class='thickbox' title='To see the content of $filef, please open $file first'> $filef</a> <br />\n "; }
									
								// IF file is a FILE!!
								else

				 					{ echo " &nbsp; &nbsp; &nbsp; <img src='$imgfile'> <a href='$file/$filef?hkeepThis=true&TB_iframe=true&height=300&width=500' class='thickbox' title='Content of $file'> $filef</a> <br />\n "; }
								
				 			}
							closedir($handlef);

				 			
				 			echo "
				 			</td> 
				 			<td>Folder </td> 
				 			<td>$roundkilo </td>
				 			<td>rm | rs </td>
				 			<td>$lastchange </td>
				 		</tr>";
				 		
				 					
			
			
			}
			
// found file is a FILE!!
			else 
			{
				 echo "<tr>
				 			<td> &nbsp; &nbsp; <img src='$imgfile' alt=''> <a href='$file?hkeepThis=true&TB_iframe=true&height=300&width=500' class='thickbox' title='Content of $file'>$file</a> &nbsp;</td> ";

						// 'known' file types (small letters!!):
						if (substr($file, -3) == "txt")
							{ echo "<td>Text file</td>"; }
						elseif (substr($file, -4) == "html" || substr($file, -3) == "htm")
							{ echo "<td>Homepage</td>"; }
						elseif (substr($file, -3) == "php")
							{ echo "<td>PHP file</td>"; }
						elseif (substr($file, -3) == "css")
							{ echo "<td>Cascading style</td>"; }
						elseif (substr($file, -3) == "rtf")
							{ echo "<td>Richtext file</td>"; }
						elseif (substr($file, -3) == "zip")
							{ echo "<td>Compressed file</td>"; }

						elseif (substr($file, -3) == "pdf")
							{ echo "<td>Portable document</td>"; }							
						elseif (substr($file, -3) == "xml")
							{ echo "<td>Extensible markup</td>"; }
						elseif (substr($file, -3) == "doc")
							{ echo "<td>Word document</td>"; }

						elseif (substr($file, -3) == "bmp")
							{ echo "<td>Image file</td>"; }
						elseif (substr($file, -3) == "png")
							{ echo "<td>Image file</td>"; }
						elseif (substr($file, -3) == "jpg")
							{ echo "<td>Image file</td>"; }
						elseif (substr($file, -3) == "jpeg")
							{ echo "<td>Image file</td>"; }
						elseif (substr($file, -3) == "gif")
							{ echo "<td>Image file</td>"; }

						elseif (substr($file, -3) == "mp3")
							{ echo "<td>Musik file</td>"; }
						elseif (substr($file, -3) == "wma")
							{ echo "<td>Windows media audio</td>"; }
							
						elseif (substr($file, -3) == "mpg")
							{ echo "<td>Video file</td>"; }
						elseif (substr($file, -3) == "mpeg")
							{ echo "<td>Video file</td>"; }

						// unknown file types (or extenstions with big letters!):
						else { echo "<td>File &nbsp;</td>"; }  
							
							
							
							
							
				 		echo "	<td>$roundkilo &nbsp;</td>

				 			<td><a href='dirlist.php?action=remove&file=$file' title='remove'>rm</a> | <a href='dirlist.php?action=restore&file=$file' title='restore'>rs</a> </td>
				 			<td>$lastchange </td>
				 		</tr>";
			}
			

		}

}

closedir($handle);


echo "</table>";

// END OF SHOWING FILES
// ==============================================




$hostname = gethostbyaddr($_SERVER['REMOTE_ADDR']);
$ip = gethostbyname($hostname);

echo "<p>&nbsp;</p>
<p style='background: url($imgstripeup); background-color: gray;'>Your Hostname: $hostname, Your IP: $ip</p>";








// end of PHP 
?>



</body>
</html>