<?php 

// =================================================================
//
//			THIS IS THE FILEEXPLORER - DIRLIST.PHP
//
//			FE by Sascha 'CyberTeddy' Schroeder
//			web:  www.cyber-inside.de
//				  blog.cyber-inside.de
//			mail: cyber at habmalnefrage dot de
//
//			=========================================
//
//			The dirlist.php is a kind of index which shows
//			a list of files n folders.
//			This dirlist.php contains the operations like 
//			rename,copy,remove and so on as well.
//
//			Note: The FileExplorer package contains: 
//			dirlist.php, fe-systemfolder and fe-trashfolder.
//			They 've to be in the same directory.
//			It's better you put all in the root-dir, 'cause FE doesn't care what's above.
//
// =================================================================



import_request_variables("gP", "rvar_");


// ======= THINGS TO SET UP FIRST ======================


// FE needs the absolute path to the fe-systemfolder 
// like: http://www.myserver.xy/fe-systemfolder

$myserver = "http://localhost:8888/fileexplorer2/fe-systemfolder";
$myserver2 = "http://localhost:8888/fileexplorer2/fe-trashfolder";


$fe = 			$myserver."/fe.gif";
$imgfile = 		$myserver."/file.gif";
$imgfolder = 	$myserver."/folder.gif";
$imgnewfolder = $myserver."/new-folder.gif";
$imgnewfile =	$myserver."/new-file.gif";
$imgfolderbig = $myserver."/folder-big.gif";
$imgstripe = 	$myserver."/stripe.gif";
$imgstripeup = 	$myserver."/stripe-up.gif";
$imgstripedown= $myserver."/stripe-down.gif";
$imgarrowdown = $myserver."/arrow-down.gif";
$imgclosebutton=$myserver."/close-button.gif";
$imgreload = 	$myserver."/reload.gif";
$imgtrashfolder=$myserver."/trash.gif";
$imgemptytrash =$myserver."/emptytrash.gif";
$imglevelup=	$myserver."/levelup.gif";
$imgroot =		$myserver."/root.gif";

$jqueryjs =		$myserver."/jquery.js";
$thickboxjs = 	$myserver."/thickbox.js";
$thickboxcss = 	$myserver."/thickbox.css";

// ======= THINGS TO SET UP FIRST ======================


?>



<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
    "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">

<head>
<title> FileExplorer </title>

<?

echo "
	<script type='text/javascript' src='$jqueryjs'></script>
	<script type='text/javascript' src='$thickboxjs'></script>

	<link rel='stylesheet' href='$thickboxcss' type='text/css' media='screen' />
	";
?>



<style type="text/css">
<!--
body {	background-color: #000000; color: #ffffff}
		
A:link {text-decoration: none; color: white;}
A:visited {text-decoration: none; color: white;}
A:active {text-decoration: none; color: white;}
A:hover {text-decoration: none; background-color: #F53D00; color: #ffffff;} //orange - white


-->
</style>





</head>
<body>

<?php // begin of PHP






// ========== COUNTING FILES IN FOLDER ============================
function countFiles($path) // COUNT FILES
					  { 
					    $result = 0; 
					    $handle=opendir($path);  
			
					    while ($filec = readdir ($handle))  
					    {  
					       if ($filec != "." && $filec != ".."   && $filec != "dirlist.php"  && $filec != "fe-systemfolder" && $filec != "fe-trashfolder")
					         $result++; 
					    }  
					   closedir($handle); 
				  	  return $result;  
					  }
					  $c1 = countFiles("./"); 
// ==========END OF COUNTING FILES IN FOLDER ====================== 







// =========== MENU ==================================

$today = date("F j, Y, g:i a"); // todays date
$currentworkdir = getcwd(); // whole long path
$basedir = basename($currentworkdir); // just the last foldername

echo "

<p style='background: url($imgstripeup); background-color: gray;'><img src='$imgclosebutton'> <b>File Explorer 2.0 beta</b></p>

<table width='100%'>
<tr>
	<td width='15%'> <img src='$fe' alt='FE-logo' border='0'> </td>
	<td width='40%'>Date: $today<br />
					$c1 objects in CurrentWorkDirectory<br />
					CWD: <b>$basedir</b><br />";
					
					
					if (file_exists("../dirlist.php")) 
						{
						echo "<a href='../dirlist.php'><img src='$imglevelup' alt='One level up' title='One level up'></a> "; 
						}
						
						echo "<a href='dirlist.php'><img src='$imgreload' alt='Reload' title='Reload'></a> 
						<a href='$myserver2/dirlist.php'><img src='$imgtrashfolder' alt='Go to trashfolder' title='Go to trashfolder'></a>  
						<a href='dirlist.php?action=newfolderform'><img src='$imgnewfolder' alt='Make new folder' title='Make new folder'></a> 
						<a href='dirlist.php?action=newfile'><img src='$imgnewfile' alt='Editor' title='Editor'></a> 
	
	</td>
					
	<td width='45%'>	FE by CyberTeddy<br /> www.cyber-inside.de<br /><br />
	
						Xtras: <!-- <a href='dirlist.php?action=editform'>Editor</a> | -->
						<a href='dirlist.php?action=uploadform'>Upload</a> | 
						<a href='dirlist.php?action=searchform'>Search</a> | 
						<a href='dirlist.php?action=checkversion'>Version</a> | 
						<a href='dirlist.php?action=diskinfo' title='Disk info'>DiskInfo</a></td>
</tr>
</table>
<p>&nbsp;</p>";
// =========== MENU ==================================







// ====================================================
// HERE ARE THE ACTIONS - should be between menu and file listing
			switch ($rvar_action) 
			{
			
				// ---- Check version
				case "checkversion" :
					
					// current Downloadable Version (don't change!)
					$cdv = "http://www.holtstraeter.com/cybercheffe/scriptsharing/php/categories/system/fileexplorer-current_version.txt";
					
					// current running version
					$crv = $myserver."/fileexplorer-current_version.txt";
					
					echo "Current Downloadable Version: "; readfile($cdv); echo "<br />";
					echo "Current Running Version: "; readfile($crv); echo "<br />";
					
					if (file($cdv) != file($crv))
					{ echo "There is a newer version of FE. [<a href='http://www.holtstraeter.com/cybercheffe/scriptsharing/php/categories/system/fileexplorer2.zip'>Download</a>]"; }
					else
					{ echo "Your version of FE is current."; }
					
					
					
				break;
				
				
				
				
				// ---- making new folder/directory
				case "newfolderform" :
				
					echo " <form action='dirlist.php?action=newfolder' method='post'>
					Enter new folder name:  <input type='text' value='New_Folder' name='newfolder'> 
					<INPUT TYPE='submit' VALUE='OK'>	
					</form>";
				
				break;
				case "newfolder" :
				
					$newfolder = $_POST['newfolder']; // post via form
				
					if (file_exists($newfolder))
						{ echo "Sorry, Folder $newfolder already exists. "; }
					else
						{
						mkdir ($newfolder, 0777);
						copy ("dirlist.php",$newfolder."/dirlist.php");
						echo "Folder $newfolder created."; }
				break;
				
				
				
				// ---- removing file/folder (and moving it to fe-trashfolder)
				case "remove" :
				
					$file = $_GET['file']; // get via link
					
					if (is_dir($file)) // A FOLDER
							{
							
							echo "<p>$file is a folder, removing a folder is NOT restorable. </p>";
							
								// look into that folder
								$handle=opendir($file);
								while ($filef = readdir ($handle))

									{

										if ($filef != "." && $filef != "..")

											{
			
												if (is_dir($filef))

												{
												 echo "Please go into $filef and click 'rm' (remove) ";
												}
												
												
												else 
												{ // if there isn't dir
												if (!file_exists(is_dir($filef)))
												  {
								
													chdir($file); // go into folder
												 	unlink($filef); // delete it's content											 echo "Done removing ".$file."/".$filef.".";
												 	chdir(".."); // back to root
												 	}
												  else // delete content except dirlist, cause we need it to go into the folder
												    {
												    chdir($file); // go into folder
												 	unlink($filef); // delete it's content											 echo "Done removing ".$file."/".$filef.".";
												 	chdir(".."); // back to root
												 	copy("dirlist.php", $file);
												    }
												 	
												 	
												}
			

											}

									}

								closedir($handle);
								
								if (is_dir($file)) // if folder is empty, remove the foler  completely
								  {
									if (rmdir($file))
										{ echo "$file removed."; }
									else
										{echo "Error removing $file. Probably not empty.";}
								   }
									
							} // end if-is_dir
					
					
					
					else // file
					{
				
						if (copy($file, "fe-trashfolder/".$file)) // works on root
							{ unlink ($file);
							echo "$file moved to fe-trashfolder. "; }
						else
							{
							echo "Error copying $file to fe-trashfolder. Removing anyway? [ <a href='dirlist.php?action=removefileanyway&file=$file'>YES</a> | <a href='dirlist.php'>NO</a> ]"; } // if trashfolder not found
						
					}
				break;
				case "removefileanyway" :
					$file = $_GET['file']; // get via link
					
					if (unlink($file))
						{ echo "$file removed. "; }
					else
						{ echo "Error removing $file."; }
				break;
				
				
				
				// ---- open a NON FE folder - only if a folder was NOT created with FE
				// To show files with FE, you need the dirlist.php
				case "nonfefolderform" :
				
					$file = $_GET['file']; // get via link
				
					echo "Folder ".$file." hasn't an index. Open anyway? [ <a href='dirlist.php?action=opennonfefolder&file=$file'>YES</a> | <a href='dirlist.php'>NO</a> ]<br /><br />
					<p>To show content of ".$file. " FE needs to make an index (copy dirlist.php into your folder). <br />
					(Requires chmod 0777 of ".$file.") </p>";
				break;
				case "opennonfefolder" :
				
					$file = $_GET['file']; // get via link
				
					if (copy ("dirlist.php", $file."/dirlist.php"))
						{echo "Index created (Copying of dirlist.php into $file done). Now you can [<a href='$file/dirlist.php'>open your folder</a>]";}
					else
						{echo "Error, FE has no permission to make an index (copy dirlist.php into $file). Function to change chmod to 0777 automatically still missing...";}
					
					break;
				
				
				
				
				// ---- duplicate a file
				case "copy" : 
				
					$file = $_GET['file']; // get via link
					
					if (file_exists("copy_".$file))
						{ echo "Can't duplicate, a copy of that file already exists."; }
						
						
						
					// if a copy does not exsists
					else // else 1
						{
						if (is_dir($file)) // A FOLDER
							{
							
								mkdir("copy_".$file, 0777);
							
								// look into that folder
								$handle=opendir($file);
								while ($filef = readdir ($handle))

									{

										if ($filef != "." && $filef != "..")

											{
			
												if (is_dir($filef))

												{
												 echo "Sorry, function to copy/duplicate subfolders still missing...";
												}
												else 
												{
												 copy ($file."/".$filef, "copy_".$file."/".$filef);
												 echo "Done.";
												}
			

											}

									}

								closedir($handle);
							} // end if-is_dir
							
							
							
						else // A FILE
						{ // else 2
						
						
							if (copy($file, "copy_".$file))
								{ echo "Done. File copied to copy_$file"; }
							else
								{ echo "Error. Could't copy/duplicate that file."; }
								
							} // else 2
							
							
						} // else 1
				
				break;
				
				
				
				
				
				// ---- rename a file or folder
				case "renameform" :
				
					$file = $_GET['file']; // get via link
					
					echo " <form action='dirlist.php?action=rename' method='post'>
					Enter new name for <input type='hidden' name='oldname' value='$file'> <b>$file</b>:  <input type='text' value='' name='newname'> 
					<INPUT TYPE='submit' VALUE='OK'>	
					</form>";
				
				break;
				case "rename" :

					$oldname = $_POST['oldname'];				
					$newname = $_POST['newname']; // post via form
					
					// filter - not allowed to save to a upper level
					$vari = stripslashes($newname);
					$array = array ("../" => "" );
					$vari = strtr($vari, $array); // apply filter $array on text $vari
					// filter
					

					if ($vari == "")
					{
						echo "Sorry, there was no value for a new name...";
					}

					else
					{
						if (!file_exists($vari))
							{
						
								if (rename($oldname, $vari))
									{ echo "Renamed to $vari."; }
								else
									{ echo "Error renaming to $vari."; }
							}
						else { echo "Error, $vari already exists."; }
					}
					
				break;
				


				
				
				// ---- move a file into a folder
				case "moveform" :
				
					$file = $_GET['file']; // get via link
					
					if (is_dir($file))
						{ echo "Sorry, Can't move a folder, just files... function still missing ;-/"; }


					else
						{
						echo " <form action='dirlist.php?action=move' method='post'>
						Moving <input type='hidden' name='file' value='$file'><b>$file</b> into folder: <input type='text' value='' name='foldername'> 
						<INPUT TYPE='submit' VALUE='OK'>	
						</form>";
						}
				break;
				case "move" :
				
					$file = 		$_POST['file']; // get via form
					$foldername = 	$_POST['foldername']; // get via form
					
					// filter - not allowed to save to a upper level
					$vari = stripslashes($foldername);
					$array = array ("../" => "" );
					$vari = strtr($vari, $array); // apply filter $array on text $vari
					// filter
					
					if ($vari == "")
						{	
							echo "Sorry, there was no value for a foldername... ";
						}
					
					else
						{
						if (copy($file, $vari."/".$file))
							{
								unlink($file);
								echo "$file moved into $vari";
							}
						else
							{ echo "Error moving $file into $vari. Probably folder does not exists."; }
						
						}
				
				break;
				
				
					
				// ---- menu chooser for a new file template
				case "newfile" :
					
					echo "Editor - Please choose a Template:<br /><br />
					
						<img src='$imgarrowdown'> <a href='dirlist.php?action=editform'>Open text based file</a><br /><br />
						
						<img src='$imgarrowdown'> <a href='dirlist.php?action=editornewblanktxtform'>Blank textfile</a><br />
						<img src='$imgarrowdown'> <a href='dirlist.php?action=editornewhtmlform'>HTML</a><br />
						<img src='$imgarrowdown'> <a href='dirlist.php?action=editornewphpform'>PHP</a><br />
						
					";
					
					break;
				
				
				
				
				
				
				// ---- edit a text/html file
				case "editform" :
				
					echo " <form action='dirlist.php?action=editor' method='post'>
					Enter a text or html file to edit:  <input type='text' value='mytext.txt' name='file'> 
					<INPUT TYPE='submit' VALUE='OK'>	
					</form>";
					break;
					
				case "editornewblanktxtform" :
					
					echo " <form action='dirlist.php?action=editornewblanktxt' method='post'>
					Enter filename:  <input type='text' value='mytxt' name='file'>.<b>txt</b>  
					<INPUT TYPE='submit' VALUE='OK'>	
					</form>";
					break;
					
				case "editornewhtmlform" :
					
					echo " <form action='dirlist.php?action=editornewhtml' method='post'>
					Enter filename:  <input type='text' value='myhtml' name='file'>.<b>html</b>  
					<INPUT TYPE='submit' VALUE='OK'>	
					</form>";
					break;
					
				case "editornewphpform" :
					
					echo " <form action='dirlist.php?action=editornewphp' method='post'>
					Enter filename:  <input type='text' value='myphp' name='file'>.<b>php</b>  
					<INPUT TYPE='submit' VALUE='OK'>	
					</form>";
					break;
					
				case "editor" : // da big textfield - FROM EDITFORM
					$file = $_POST['file']; // via editform
					
					// filter - not allowed to save to a upper level
					$vari = stripslashes($file);
					$array = array ("../" => "" );
					$vari = strtr($vari, $array); // apply filter $array on text $vari
					// filter
					
					echo "<form action='dirlist.php?action=editorsave' method='post'>";

					 echo "
					 <table>
					 <tr>
					 	<td align='right'> $vari: <input type='hidden' value='$vari' name='file'>  
						<INPUT TYPE='submit' VALUE='Save document'>
						</td>
					<tr>
						<td>
						<textarea name='text' rows='20' cols='70' wrap='phisical'>";
						@readfile("$vari");
						echo "</textarea>
						</td>
					
					</table>
					</form>";
				break;
				case "editorfromdirlist" : // da big textfield - FROM DIRLIST
				
					
					$file = $_GET['file']; // via dirlist-link
					
					echo "<form action='dirlist.php?action=editorsave' method='post'>";

					 echo "
					 <table>
					 <tr>
					 	<td align='right'> $file: <input type='hidden' value='$file' name='file'>  
						<INPUT TYPE='submit' VALUE='Save document'>
						</td>
					<tr>
						<td>
						<textarea name='text' rows='20' cols='70' wrap='phisical'>";
						@readfile("$file");
						echo "</textarea>
						</td>
					
					</table>
					</form>";
					
				break;
					
					
				case "editornewblanktxt" : // da big textfield - NEW TXT
					
					
					$file = $_POST['file'].".txt"; 
					
					echo "<form action='dirlist.php?action=editorsave' method='post'>";
					
					echo "
					<table>
					<tr>
					<td align='right'> $file: <input type='hidden' value='$file' name='file'>  
					<INPUT TYPE='submit' VALUE='Save document'>
					</td>
					<tr>
					<td>
					<textarea name='text' rows='20' cols='70' wrap='phisical'></textarea>
					</td>
					
					</table>
					</form>";
					
					break;					
					
					
				case "editornewhtml" : // da big textfield - NEW HTML
					
					
					$file = $_POST['file'].".html"; // via dirlist-link
					
					echo "<form action='dirlist.php?action=editorsave' method='post'>";
					
					echo "
					<table>
					<tr>
					<td align='right'> $file: <input type='hidden' value='$file' name='file'>  
					<INPUT TYPE='submit' VALUE='Save document'>
					</td>
					<tr>
					<td>
					<textarea name='text' rows='20' cols='70' wrap='phisical'>";
					@readfile("$myserver/xhtml1.0-template");
					echo "</textarea>
					</td>
					
					</table>
					</form>";
					
					break;
				case "editornewphp" : // da big textfield - NEW PHP
					
					
					$file = $_POST['file'].".php"; // 
					
					echo "<form action='dirlist.php?action=editorsave' method='post'>";
					
					echo "
					<table>
					<tr>
					<td align='right'> $file: <input type='hidden' value='$file' name='file'>  
					<INPUT TYPE='submit' VALUE='Save document'>
					</td>
					<tr>
					<td>
					<textarea name='text' rows='20' cols='70' wrap='phisical'>";
					@readfile("$myserver/php-template");
					echo "</textarea>
					</td>
					
					</table>
					</form>";
					
					break;
					
				case "editorsave" : // save da big textfield
				
					$file = $_POST['file'];
					$text = $_POST['text'];

					$fo =fopen($file,"w");
					fwrite ($fo,stripslashes($text)); 
					fclose($fo);
					echo "<p> File '$file' saved.</p>";
					
				break;
					
				
				
				// ---- upload a file
				case "uploadform" :
					echo "Choose a file to upload:";
					
					echo "
					<form action='dirlist.php?action=upload' method='post' enctype='multipart/form-data'>
					<input type='file' name='probe' />
					<input type='submit' value='Upload' />
					</form> ";	
				break;
				case "upload":
				if (isset($_FILES['probe']) and ! $_FILES['probe']['error']) {
		    		// Alternativ:            and   $_FILES['probe']['size']
		    		move_uploaded_file($_FILES['probe']['tmp_name'], $_FILES['probe']['name']);   //"./newfile.txt");
		    
		    		chmod($_FILES['probe']['name'], 0777);
		    
		   			 printf("File %s is now uploaded.\n",
		      			$_FILES['probe']['name']);
		
				// rename("newfile.txt", $_FILES['probe']['name']);
		
		  		}
				break;
				


				// ---- search for file/folder (inside your CWD!) if your list is to long and you can't find it
				case "searchform" :
					echo " Search:<br />
					<form action='dirlist.php?action=searchfile' method='post'>
					Looking for file:  <input type='text' value='filename.txt' name='file' size='24'> 
					<INPUT TYPE='submit' VALUE='OK'>	
					</form><br />
					
					<form action='dirlist.php?action=searchfileextension' method='post'> 
					Looking for files with this extension:	*.<input type='text' name='myfile' value='txt' size='4' maxlength='6'> <INPUT TYPE='submit' VALUE='OK'>
					</form>";
				break;				
				case "searchfile" :
					$getfile = $_POST['file'];
					
					// filter - not allowed to save/SEE to a upper level
					$file = stripslashes($getfile);
					$array = array ("../" => "" );
					$file = strtr($file, $array); // apply filter $array on text $file
					// filter
					
					// properties of file:
					$filesizebytes = filesize($file);
					$filesizekilo = $filesizebytes / 1024;
					$roundkilo = round($filesizekilo,2);
			
					$lastchange = date ('Y-m-d H:m', filemtime($file));
					
					
					if(file_exists($file))
					{
					if (!is_dir($file)) // IS FILE
						{
					
						echo "Result:<br />
						
							<table width='100%'>
							<tr>
								<td style='background: url($imgstripe); background-color: gray;'>Name</td>
								<td style='background: url($imgstripe); background-color: gray;'>Size (KB)</td>
								<td style='background: url($imgstripe); background-color: gray;'>Actions</td>
								<td style='background: url($imgstripe); background-color: gray;'>Last modified</td>
							</tr>
						
							<tr>
				 				<td> &nbsp; &nbsp; <img src='$imgfile' alt=''> <a href='$file?hkeepThis=true&TB_iframe=true&height=300&width=500' class='thickbox' title='Content of $file'>$file</a> &nbsp;</td>
				 				
				 				<td>$roundkilo</td>
				 				<td><a href='dirlist.php?action=remove&file=$file' title='remove $file'>rm</a> | 
				 			<a href='dirlist.php?action=moveform&file=$file' title='move $file'>mv</a> | 
				 			<a href='dirlist.php?action=copy&file=$file' title='copy $file'>cp</a> | 
				 			<a href='dirlist.php?action=renameform&file=$file' title='rename $file'>rn</a> ";
							
						// show special action to special file 	
						// editable TEXTBASED files:
						if (substr($file, -3) == "txt" || substr($file, -4) == "html" || substr($file, -3) == "htm" || substr($file, -3) == "css" || substr($file, -3) == "php" || substr($file, -3) == "csv" || substr($file, -3) == "xml")
							{
							echo "| <a href='dirlist.php?action=editorfromdirlist&file=$file' title='edit $file'>edit</a> &nbsp;";
							}
						else
							{ echo ""; }
							echo "</td>
				 			<td>$lastchange </td>
				 			
				 			</tr>
				 			</table>";
				 			
				 			echo "<div align='center'><p>&nbsp;</p><hr width='60%'></div>";
				 			
				 			echo "<pre>
				 		
				 		
				 		
				 		
				 		
				 		</pre>";
					
						}// !is_dir
						
					else // is FOLDER
						{
						
						echo "Result:<br />
						
							<table width='100%'>
							<tr>
								<td style='background: url($imgstripe); background-color: gray;'>Name</td>
								<td style='background: url($imgstripe); background-color: gray;'>Size (KB)</td>
								<td style='background: url($imgstripe); background-color: gray;'>Actions</td>
								<td style='background: url($imgstripe); background-color: gray;'>Last modified</td>
							</tr>

							<tr>
				 				<td><img src='$imgarrowdown' alt=''> <img src='$imgfolder' alt=''> ";
				 			if (file_exists($file."/dirlist.php"))
				 				{ echo "<a href='$file/dirlist.php'>$file</a> &nbsp;<br />"; }
				 			else
				 				{ echo "<a href='dirlist.php?action=nonfefolderform&file=$file'>$file</a> &nbsp;<br />";}
				 				echo "</td>
				 				
				 				<td>$roundkilo</td>
				 				<td><a href='dirlist.php?action=remove&file=$file' title='remove $file'>rm</a> | 
				 			<a href='dirlist.php?action=moveform&file=$file' title='move $file'>mv</a> | 
				 			<a href='dirlist.php?action=copy&file=$file' title='copy $file'>cp</a> | 
				 			<a href='dirlist.php?action=renameform&file=$file' title='rename $file'>rn</a></td>
				 			<td>$lastchange </td>
				 			
				 			</tr>
				 			</table>";
				 			
				 			echo "<div align='center'><p>&nbsp;</p><hr width='60%'></div>";
				 			
				 			echo "<pre>
				 		
				 		
				 		
				 		
				 		
				 		</pre>";
						}
						
					} // if file_exists
					else { echo "Sorry, $file does NOT exists."; }								
				break;	
				case "searchfileextension" :
					$myfile = $_POST['myfile'];
					
					
					echo "Resultat<br />
					
					<table width='100%'>
					
					<tr>
								<td style='background: url($imgstripe); background-color: gray;'>Name</td>
								<td style='background: url($imgstripe); background-color: gray;'>Size (KB)</td>
								<td style='background: url($imgstripe); background-color: gray;'>Actions</td>
								<td style='background: url($imgstripe); background-color: gray;'>Last modified</td>
							</tr>

					";
					
					$handle=opendir('.');
					while ($file = readdir ($handle)) {
					if ($file != "." && $file != ".." && $file != "fe-systemfolder" && $file != "fe-trashfolder" && $file != "dirlist.php" && strpos($file, $myfile)) {
					
					// properties of file:
					$filesizebytes = filesize($file);
					$filesizekilo = $filesizebytes / 1024;
					$roundkilo = round($filesizekilo,2);
			
					$lastchange = date ('Y-m-d H:m', filemtime($file));
					
						echo "
						<tr>
				 				<td> &nbsp; &nbsp; <img src='$imgfile' alt=''> <a href='$file?hkeepThis=true&TB_iframe=true&height=300&width=500' class='thickbox' title='Content of $file'>$file</a> &nbsp;</td>
				 				
				 				<td>$roundkilo</td>
				 				<td><a href='dirlist.php?action=remove&file=$file' title='remove $file'>rm</a> | 
				 			<a href='dirlist.php?action=moveform&file=$file' title='move $file'>mv</a> | 
				 			<a href='dirlist.php?action=copy&file=$file' title='copy $file'>cp</a> | 
				 			<a href='dirlist.php?action=renameform&file=$file' title='rename $file'>rn</a> ";
							
						// show special action to special file 	
						// editable TEXTBASED files:
						if (substr($file, -3) == "txt" || substr($file, -4) == "html" || substr($file, -3) == "htm" || substr($file, -3) == "css" || substr($file, -3) == "php" || substr($file, -3) == "csv" || substr($file, -3) == "xml")
							{
							echo "| <a href='dirlist.php?action=editorfromdirlist&file=$file' title='edit $file'>edit</a> &nbsp;";
							}
						else
							{ echo ""; }
							echo "</td>
				 			<td>$lastchange </td>
				 			
				 			</tr>";
				 			
						}
						
					}
  					closedir($handle);
					echo "</table>";
					
				 			echo "<div align='center'><p>&nbsp;</p><hr width='60%'></div>";
				 			
				 			echo "<pre>
				 		
				 		
				 		
				 		
				 		
				 		</pre>";
					
				break;
				
				
				
					
					
				// ---- the diskinfo may notwork on every server(configuration).
				// it works on localhost :)
				case "diskinfo" :
					echo "<p>Diskinfo may not work with your configuration</p>";
					@include($myserver."/diskinfo.php");
					
				break;
					

			} // end of switch $action

// END OF ACTIONS
// ==============================================











// ==============================================
// HERE IS FILEEXPLORER SHOWING YOUR FILES

echo "<p>&nbsp;</p>
	<table width='100%'>
	<tr>
		<td style='background: url($imgstripe); background-color: gray;'>Name</td>
		<td style='background: url($imgstripe); background-color: gray;'>Kind</td>
		<td style='background: url($imgstripe); background-color: gray;'>Size (KB)</td>
		<td style='background: url($imgstripe); background-color: gray;'>Actions</td>
		<td style='background: url($imgstripe); background-color: gray;'>Last modified</td>
	</tr>";

$handle=opendir('.');

while ($file = readdir ($handle))

{

		if ($file != "." && $file != ".." && $file != "fe-systemfolder" && $file != "fe-trashfolder" && $file != "dirlist.php")

		{
			// properties of file:
			$filesizebytes = filesize($file);
			$filesizekilo = $filesizebytes / 1024;
			$roundkilo = round($filesizekilo,2);
			
			$lastchange = date ('Y-m-d H:m', filemtime($file));
			
			
			

			
			// found file is a FOLDER!!
			if (is_dir($file))

			{
				 echo "<tr>
				 			<td><img src='$imgarrowdown' alt=''> <img src='$imgfolder' alt=''> ";
				 			if (file_exists($file."/dirlist.php"))
				 				{ echo "<a href='$file/dirlist.php'>$file</a> &nbsp;<br />"; }
				 			else
				 				{ echo "<a href='dirlist.php?action=nonfefolderform&file=$file'>$file</a> &nbsp;<br />";}
				 			  
				 		
				 		/* *************************************** 
				 		//IF FOLDER COMNTAINS SOMETHING, SHOW IT TOO
				 		$handlef=opendir($file);
				 		while ($filef = readdir ($handlef))

							{

								if ($filef != "." && $filef != ".." && $filef != "fe-systemfolder" && $filef != "fe-trashfolder" && $filef != "dirlist.php")
								
								
								// IF file is  a FOLDER!!
								if (is_dir($file."/".$filef))
									{ echo " &nbsp; &nbsp; &nbsp; <img src='$imgfolder'> <a href='$imgfolderbig?hkeepThis=true&TB_iframe=true&height=300&width=500' class='thickbox' title='To see the content of $filef, please open $file first'> $filef</a> &nbsp;<br />\n "; }
									
								// IF file is a FILE!!
								else

				 					{ echo " &nbsp; &nbsp; &nbsp; &nbsp; <img src='$imgfile'> <a href='$file/$filef?hkeepThis=true&TB_iframe=true&height=300&width=500' class='thickbox' title='Content of $file'> $filef</a>  &nbsp; <br />\n "; }
								
				 			}
							closedir($handlef);
						*************************************** */
				 			
				 			echo "
				 			</td> 
				 			<td>Folder &nbsp;</td> 
				 			<td>$roundkilo &nbsp;</td>
				 			<td><a href='dirlist.php?action=remove&file=$file' title='remove $file'>rm</a> | 
				 			<a href='dirlist.php?action=moveform&file=$file' title='move $file'>mv</a> | 
				 			<a href='dirlist.php?action=copy&file=$file' title='copy $file'>cp</a> | 
				 			<a href='dirlist.php?action=renameform&file=$file' title='rename $file'>rn</a> &nbsp;</td>
				 			<td>$lastchange </td>
				 		</tr>";
				 		
				 					
			
			
			}
			
			// found file is a FILE!!
			else 
			{
				 echo "<tr>
				 			<td> &nbsp; &nbsp; <img src='$imgfile' alt=''> <a href='$file?hkeepThis=true&TB_iframe=true&height=300&width=500' class='thickbox' title='Content of $file'>$file</a> &nbsp;</td> ";

						// 'known' file types (small letters!!):
						if (substr($file, -3) == "txt")
							{ echo "<td>Text file</td>"; }
						elseif (substr($file, -4) == "html" || substr($file, -3) == "htm")
							{ echo "<td>Homepage</td>"; }
						elseif (substr($file, -3) == "php")
							{ echo "<td>PHP file</td>"; }
						elseif (substr($file, -3) == "css")
							{ echo "<td>Cascading style</td>"; }
						elseif (substr($file, -3) == "rtf")
							{ echo "<td>Richtext file</td>"; }
						elseif (substr($file, -3) == "zip")
							{ echo "<td>Compressed file</td>"; }

						elseif (substr($file, -3) == "pdf")
							{ echo "<td>Portable document</td>"; }							
						elseif (substr($file, -3) == "xml")
							{ echo "<td>Extensible markup</td>"; }
						elseif (substr($file, -3) == "doc")
							{ echo "<td>Word document</td>"; }

						elseif (substr($file, -3) == "bmp")
							{ echo "<td>Image file</td>"; }
						elseif (substr($file, -3) == "png")
							{ echo "<td>Image file</td>"; }
						elseif (substr($file, -3) == "jpg")
							{ echo "<td>Image file</td>"; }
						elseif (substr($file, -3) == "jpeg")
							{ echo "<td>Image file</td>"; }
						elseif (substr($file, -3) == "gif")
							{ echo "<td>Image file</td>"; }

						elseif (substr($file, -3) == "mp3")
							{ echo "<td>Musik file</td>"; }
						elseif (substr($file, -3) == "wma")
							{ echo "<td>Windows media audio</td>"; }
							
						elseif (substr($file, -3) == "mpg")
							{ echo "<td>Video file</td>"; }
						elseif (substr($file, -3) == "mpeg")
							{ echo "<td>Video file</td>"; }

						// unknown file types (or extenstions with big letters!):
						else { echo "<td>File &nbsp;</td>"; }  
							
							
							
							
							
				 		echo "	<td>$roundkilo &nbsp;</td>
				 			<td><a href='dirlist.php?action=remove&file=$file' title='remove $file'>rm</a> | 
				 			<a href='dirlist.php?action=moveform&file=$file' title='move $file'>mv</a> | 
				 			<a href='dirlist.php?action=copy&file=$file' title='copy $file'>cp</a> | 
				 			<a href='dirlist.php?action=renameform&file=$file' title='rename $file'>rn</a> ";
							
						// show special action to special file 	
						// editable TEXTBASED files:
						if (substr($file, -3) == "txt" || substr($file, -4) == "html" || substr($file, -3) == "htm" || substr($file, -3) == "css" || substr($file, -3) == "php" || substr($file, -3) == "csv" || substr($file, -3) == "xml")
							{
							echo "| <a href='dirlist.php?action=editorfromdirlist&file=$file' title='edit $file'>edit</a> &nbsp;";
							}
						else
							{ echo ""; }
							
							
							echo "</td>
				 			<td>$lastchange </td>
				 		</tr>";
			}
			

		}

}

closedir($handle);


echo "</table>";

// END OF SHOWING FILES
// ==============================================





// ===============================================
// The rest... let it stay or die......
$hostname = gethostbyaddr($_SERVER['REMOTE_ADDR']);
$ip = gethostbyname($hostname);

echo "<p>&nbsp;</p>
<p style='background: url($imgstripeup); background-color: gray;'>Your Hostname: $hostname, Your IP: $ip</p>";
// =================================================







// end of PHP 
?>



</body>
</html>